// demonstration of chaotic behavior with a logistic map
// (as described in Melanie Mitchell's book "Complexity")
// note: replacing "d" for "x" in the classic equation

int num = 3;
float x = 0;
float y = 200;
float oldX = 0;
float oldY = 200;
float R = 2.9;   // for "environmental variables"
float d = .5;    // Below 1.0 for interesting behaviors

void setup() {
  size(1000, 400);
  stroke(150, 200, 200);
  strokeWeight(2);
  smooth();
  background(0);
  
  frameRate(60);
}

void draw() {
  // age time step
  oldX = x;
  oldY = y;
  
 // Calculate
  d = (R*d)*(1-d);
  R = R + .0008385;

 // Scale
    y = 60 + (d * 200); // Change is scaled to make more visible
    x = x + .75; 
    println(d); 
 // Draw
    if( R > 3.075 ) { stroke(250, 150, 150); }
    if( R > 3.53 ) { stroke(250, 250, 200); }
    ellipse(oldX, oldY, 2.0, 2.0);

  //-- run different color changed by a 10 millionth
  if(x > 1000) {
    ellipse(x, x, 1, 1);
   }
}