#!/usr/bin/python3

from tkinter import *

def str_to_hex(str):
    return ''.join('{:02x}'.format(ord(c)) for c in str)

def sel(var):
    varR = int(var1.get())
    varR = hex(varR)[2:]
    varR = str(varR)
    if int(var1.get()) < 16:
        varR = "0" + varR
    varG = int(var2.get())
    varG = hex(varG)[2:]
    varG = str(varG)
    if int(var2.get()) < 16:
        varG = "0" + varG
    varB = int(var3.get())
    varB = hex(varB)[2:]
    varB = str(varB)
    if int(var3.get()) < 16:
        varB = "0" + varB
    values3.config(text=varR + " "+ varG +" "+ varB, font=("Verdana", 12),  background='#f9f9f9')
    hexStr = "#"+varR+varG+varB
    can.config(bg=hexStr)

master = Tk()

var1 = IntVar()
var2 = IntVar()
var3 = IntVar()

master.geometry('360x340+600+300')
master.title('RGB Color Mixer')
master.configure(background='#efefef')

can = Canvas(master, width=140, height=130)
can.place(x=108, y=10)

values = Label(master)
values.place(x=70, y=155)
values.config(text="RGB values = #", font=("Verdana", 12), background='#efefef')

values3 = Label(master)
values3.place(x=210, y=155)

R = Label(master)
R.place(x=24, y=205)
R.config(background="#efefef", text="R:",font=("Verdana", 12), fg='#900')

G = Label(master)
G.place(x=24, y=245)
G.config(background="#efefef", text="G:",font=("Verdana", 12), fg='#090')

B = Label(master)
B.place(x=24, y=285)
B.config(background="#efefef", text="B:",font=("Verdana", 12), fg='#009')

w1 = Scale(master, variable=var1, from_=0, to=255, length=280, troughcolor='#faa',  orient=HORIZONTAL, command=sel)
w1.place(x=50, y=190)
w1.configure(background='#efefef')
w2 = Scale(master, variable=var2, from_=0, to=255, length=280, troughcolor='#afa', orient=HORIZONTAL, command=sel)
w2.place(x=50, y=230)
w2.configure(background='#efefef')
w3 = Scale(master, variable=var3, from_=0, to=255, length=280, troughcolor='#9ef', orient=HORIZONTAL, command=sel)
w3.place(x=50, y=270)
w3.configure(background='#efefef')

mainloop()

