// Based on Processing Visualization project by Erich Izdepski:
// https://erichizdepski.wordpress.com/2016/01/15/music-visualization-with-processing/

import ddf.minim.*;
import ddf.minim.analysis.*;

Minim minim;
AudioPlayer player;
FFT fft;

void setup()
{
//app window size
size(1200, 800);
minim = new Minim(this);
//CHANGEME choose an audio file from your system or the web
player = minim.loadFile("Oh_Sailor.mp3");
player.play();

//setup the FFT to process this audio file
fft = new FFT(player.bufferSize(), player.sampleRate());
}

//for storing the real and imaginary components of a frequency band
float[] real;
float[] img;

void draw()
{
fill(50, 20);
rect(0,0, width, height);
//rgba format
stroke(200, 100, 0, 70);
strokeWeight(6); // Thicker

//perform a forward fft on a buffer of audio
fft.forward(player.mix);
real = fft.getSpectrumReal();
img = fft.getSpectrumImaginary();

//use for centering the rendering in the window
int xOffset = (width - fft.specSize())/2;

//get the number of frequency bands and draw each one
for (int i = 0; i < fft.specSize(); i++)
{
//line API is for point to point drawing using these coordniates:
//x1, y1, x2, y2
stroke(real[i] * 25, img[i] * 25, fft.getBand(i)*2, 170);
//use polar coordinates
//can use real(x) and imaginary(y) data for this
//line (i + xOffset, height/2, i + xOffset + real[i] * 20, height/2 + img[i] * 20);
line(i + xOffset, height/2, i + xOffset + real[i] * 10, height/2 + img[i] * 10);
}
}
