//-----------------------------------------------------
// Data Scraping   ( based on code by Daniel Shiffman )
//
// It uses a function called "giveMeTextBetween()" which 
// takes 3 arguments: String, first-substring, second-substring
// and then returns the substring between.
// It also uses a function called "printIt()" which takes 3
// arguments: String-to-print, X-location and Y-location
//
// This example gets the temperaature and weather from a webpage.
// ----------------------------------------------------

String url = "https://www.boston.com/section/weather";
String onelongstring;
int startY = 150;
PFont f; // Global font variable
int x = 20; // Horizontal location
int index = 0;
String temp;
String weather;
int lineCounter = 0;

void setup() {
  background(255);
  size(900,300);
  f = createFont( "Arial", 48, true);
  textFont(f);
  textAlign(LEFT);
}

void draw() {
  background(255);
  fill (0);
  // Display headline at x location
  textFont(f,48);
  textAlign (LEFT);
 String[] lines = loadStrings(url);
// println(lines.length);
 onelongstring = join(lines, " ");
 temp = giveMeTextBetween( onelongstring,  "weather-current__actual-temp\">", "&deg;");
 weather = giveMeTextBetween( onelongstring,  "class=\"weather-current__condition-text\">", "</div");
 
 printIt(temp, 100, startY);
 printIt("degrees,", 220, startY);
 printIt(weather, 380, startY);
  }

void printIt(String getStr, int getX, int startY) {
   text(getStr,getX, startY );
}

// A function that returns a substring between two substrings
String giveMeTextBetween(String s, String startTag, String endTag) { 
  // Find the index of the beginning tag
  int startIndex = s.indexOf(startTag);
  // If I don't find anything
  if (startIndex == -1) {
    return "";
  }
  // Move to the end of the beginning tag
  startIndex += startTag.length();
  // Find the index of the end tag
  int endIndex = s.indexOf(endTag, startIndex); 
  // If I don't find the end tag,
  if (endIndex == -1) {
    return "";
  }
  // Return the text in between
  return s.substring(startIndex, endIndex);
}
