/* ---------- analog_Sensor sends data to Serial -------------
 *
 *   Hardware Setup- a voltage divider connected to analog 5 :
 *   1) -Wire a photoresister between +5vdc and an empty row on the breadboard
 *   2) -Wire a 10k resistor between that same row on the breadboard to ground.
 *   3) -Jumper wire from that same row to the last pin on the chip (analog 5)
 *                               or
 *   1) -Wire the outer pins of a pot to +5v and Gnd 
 *   2) -Wire the middle pin (wiper) to analog pin A%
 *-------------------------------------------------------------------------*/

int a_in;               // create variable for storing analog readings
int sensorPin = A5;     // variable for analog pin as A5

void setup() {
  Serial.begin(9600);
}

void loop() {
  // read sensor, store in variable, print
  a_in = analogRead(sensorPin);       // get 10 bit analog value
  a_in = map(a_in, 0, 1023, 0, 255);  // scale it to 8 bits
  Serial.println(a_in);
  
  delay(50);                          // easier to read screen
}


