// This code was adapted from:
// Learning Processing by Daniel Shiffman
// Example 10-10: The raindrop catching game

Catcher catcher;    // One catcher object
Timer timer;        // One timer object
Drop[] drops;       // An array of drop objects
int totalDrops = 0; // totalDrops
//-----------------------------------------
import ddf.minim.*;
Minim minim;
AudioSample dropSnd;
int dropCount = 0;
int colorCountR = 0;
int colorCountG = 255;
int colorCountB = 255;
String counter;
PImage img;         // Declare variable of type PImage

void setup() {
  minim = new Minim(this);  // create instance of sound object
  dropSnd = minim.loadSample("waterDrop.wav", 1024); 
  if ( dropSnd == null ) println("Didn't get waterDrop.wav!");
  PFont f = loadFont("ArialMT-36.vlw");
  textFont(f, 42);
  size(800,600);
  smooth();
  noCursor();
  img = loadImage("hand.png"); 
  catcher = new Catcher(85); // Create the catcher with a radius of 32
  drops = new Drop[1000];    // Create 1000 spots in the array
  timer = new Timer(300);   // Create a timer that goes off every 2 seconds
  timer.start();             // Starting the timer
}

void draw() {
  background(12);
  
  // Set catcher location
  catcher.setLocation(mouseX,mouseY); 
  // Display the catcher
  catcher.display(); 
  
  // Check the timer
  if (timer.isFinished()) {
    // Deal with raindrops
    // Initialize one drop
    drops[totalDrops] = new Drop();
    // Increment totalDrops
    totalDrops ++ ;
    // If we hit the end of the array
    if (totalDrops >= drops.length) {
      totalDrops = 0; // Start over
    }
    timer.start();
  }
  
  // Move and display all drops
  fill(colorCountR, colorCountG, colorCountB);
  counter = str(dropCount);
  text(counter, 400, 550);
  for (int i = 0; i < totalDrops; i++ ) {
    drops[i].move();
    drops[i].display();
    if (catcher.intersect(drops[i])) {
      drops[i].caught();
    }
  }
}
