/**
 * Load and Display 
 * Images can be loaded and displayed to the screen at their actual size
 * or any other size. 
 */
PImage img_bk, eye, nose, mouth;  // Declare variable of type PImage

import processing.serial.*;
Serial myPort;          // The serial port
String serialString;  // variable for storing serial data
int val;                // for storing number re-cast from string

void setup() {
  size(900, 672);
  // image file must be in the data folder of the current sketch 
  // to load successfully
  img_bk = loadImage("pino_bkg.png");  // Load the image 
  eye = loadImage("eye.png");          // Load the image 
  nose = loadImage("nose.png");        // Load the image 
  mouth = loadImage("mouth.png");      // Load the image 
      // List all the available serial ports:
  printArray(Serial.list());
  // Open the port you are using at the rate you want:
  myPort = new Serial(this, Serial.list()[3], 9600);
}

void draw() {
  image(img_bk, 0, 0);
//  image(eye, 0, height/2, img.width/2, img.height/2);
 imageMode(CENTER);
 image(eye, 420, 345, 83, 170);
 imageMode(CORNER);
 image(nose, 460, 380, 180, 103);
 image(mouth, 428, 490, 79, 45);
}

//---- The SerialEvent function runs continuously in the background and
//---- stores new values whenever new data comes in on the serial port (USB)

void serialEvent(Serial myPort) {
   serialString = myPort.readStringUntil(10); // Read until end of line character
   if (serialString != null) {
     serialString = trim(serialString); 
     val = int(serialString);
     println(val);
   }                               // end if
}