/**
 * Loop. 
 * Shows how to load and play a QuickTime movie file.  
 */

import processing.video.*;

Movie movie;

void setup() {
  size(1100, 650);
  background(0);
  imageMode(CENTER);
  noCursor();
  fill(0, 5);                    //--- 2 arguments to fill = greyscale and alpha
  movie = new Movie(this, "cat.mov");   // Load and play the video in a loop
  movie.loop();
}

void movieEvent(Movie m) {
  m.read();
}

void draw() {
  image(movie, mouseX, mouseY, 640, 480);
  rect(0,0, width, height);
}