/* Processing code:
 * Example of animation playing back using Serial data 
 * to select index numbers in an array of images
 *--------------------------------------------------------------*/
 
 import processing.serial.*;
 Serial myPort;
 String serialString;                     // variable for storing serial data
 int val;                                 // variable for re-casting ASCII to integers
 int mappedSerial;                        // variable for data scaled to number of images
 int numFrames = 13;                      // The number of frames in the animation
 PImage[] images = new PImage[numFrames];

  void setup() {
    frameRate(30);
    size(793, 598);
    background(0, 0, 0);   // color (r, g, b)
    // Load consecutively-numbered jpgs into an array:
    // The nf() command does number formatting, which will
    // ensure that the number is (in this case) 2 digits.
    for (int i = 0; i < numFrames; i++) {
      String imageName = "sloth" + nf(i, 2) + ".jpg";
      images[i] = loadImage(imageName);
       }
    smooth();
    println(Serial.list());   // Diagnostic: gives list of ports
    myPort = new Serial(this, Serial.list()[1], 9600);
   } 
 
// draw listens to serial port, calls serialEvent, draws   
  void draw() {  
    mappedSerial = int(map(val, 0, 255, 0, 12)); //-- map data to # of images in array
    background(0, 0, 0);                 // clear the screen
    image(images[mappedSerial], 0, 0);
}


//---- The SerialEvent function runs continuously in the background and
//---- stores new values whenever new data comes in on the serial port (USB)

void serialEvent(Serial myPort) {
   serialString = myPort.readStringUntil(10); // Read until end of line character
   if (serialString != null) {
     serialString = trim(serialString); 
     val = int(serialString);
     println(val);
   }                               // end if
}