//
// Object Oriented Example: An Array of Car objects
// -- Adapted from Dan Shiffman's tutorials
//
Car[] myCar = new Car[25];   //Create the array of Car objects with a given size


void setup() {
  size(600,600);
  // Parameters go inside the parentheses when the object is constructed.
  for(int i = 0; i < myCar.length; i++){
  myCar[i] = new Car(color(random(255),random(255),random(255)), random(600), random(600), random(5));
  }
}

void draw() {
  background(255);
for(int i = 0; i < myCar.length; i++){
  myCar[i].drive();
  myCar[i].display();
  }
}

// Even if we use multiple objects, we still only need one class. 
// No matter how many cookies we make, only one cookie cutter is needed.
class Car { 
  color c;
  float xpos;
  float ypos;
  float xspeed;

  // The Constructor is defined with arguments.
  Car(color tempC, float tempXpos, float tempYpos, float tempXspeed) { 
    c = tempC;
    xpos = tempXpos;
    ypos = tempYpos;
    xspeed = tempXspeed;
  }

  void display() {
    strokeWeight(3);
    stroke(0);
    fill(c);
    rectMode(CENTER);
    rect(xpos,ypos,20,10);
  }

  void drive() {
    xpos = xpos + xspeed;
    if (xpos > width) {
      xpos = 0;
    }
  }
}
