//
// Shiffman example: Car objects spacialized
//

// An array of 100 Car objects!
Car[] cars = new Car[100]; 

void setup() {
  size(700, 450);
  // Initialize each Car using a for loop.
  for (int i = 0; i < cars.length; i ++ ) { 
    cars[i] = new Car(color(i*2.5), 0 + (i* 2), i*2, i/20.0);
  }
}

void draw() {
  background(255);
  // Run each Car using a for loop.  
  for (int i = 0; i < cars.length; i++) { 
    cars[i].drive();
    cars[i].display();
  }
}

// Even if we use multiple objects, we still only need one class. 
// No matter how many cookies we make, only one cookie cutter is needed.
class Car { 
  color c;
  float xpos;
  float ypos;
  float xspeed;

  // The Constructor is defined with arguments.
  Car(color tempC, float tempXpos, float tempYpos, float tempXspeed) { 
    c = tempC;
    xpos = tempXpos;
    ypos = tempYpos;
    xspeed = tempXspeed;
  }

  void display() {
    strokeWeight(1);
    stroke(0);
    fill(c);
    rectMode(CENTER);
    rect(xpos,ypos,40,20);
  }

  void drive() {
    xpos = xpos + xspeed;
    if (xpos > width) {
      xpos = 0;
    }
  }
}
