// ----  Random Dispersal example for OSCON by Dana Moser
//      (Creates and animates "brownian noise" oscillating ellipses)
// ----  This code is in the public domain.

int howMany = 300;

float[] x = new float[howMany];       // Create arrays for x, y
float[] y = new float[howMany];

void setup() {
  size(900, 600);                 // Creates a 900x600 pixel window

  for (int i=0; i < howMany; i=i+1) {
    x[i] = random(430, 480);      //--Load in initial location for each
    y[i] = random(290, 310);
   }
}

void draw() {
  background(0, 10, 10);    // (Red, Green, Blue) (0-255)
  fill(230, 255, 235, 40);  // (R, G, B and Alpha)
  stroke(100, 0, 0, 200);
  strokeWeight(0.2);
  noStroke();

  for (int i=0; i < howMany; i=i+1) {  //---for each element

    x[i] = x[i] + random(-2,2);        //--- move
    y[i] = y[i] + random(-2,2);

    ellipse(x[i], y[i], 30, 30);       //--- draw ellipse x, y
  }
}