/*
 * CapitiveSense Library Demo Sketch
 * original Paul Badger 2008
 * modified by Fred Wolflink for MassArt 2-23-2012
 * Uses a high value resistor e.g. 1 megohm between send pin and receive pin
 * Resistor effects sensitivity, experiment with values, 50 kilohm - 50 megohm. Larger resistor values yield larger sensor values.
 * Receive pin is the sensor pin - try different amounts of foil/metal on this pin
 * Best results are obtained if sensor foil and wire is covered with an insulator such as paper or plastic sheet
 *
 * see: www.arduino.cc/playground/Main/CapSense
 */
 
#include <CapSense.h>

CapSense cs_2_4 = CapSense(2,4);        // Digital Pins 4 & 2, pin 4 is sensor pin

int ledPin = 7;

void setup()                    
{
  Serial.begin(9600);
  pinMode(ledPin, OUTPUT);   // LED
}

void loop()                    
{
  long start = millis();
   // argument is number of samples - fewer is more sensitve and less stable
  long total =  cs_2_4.capSense(30);

  Serial.print( millis() - start );    // check on performance in milliseconds
  Serial.print("\t");                  // tab character for debug windown spacing
  Serial.println(total);               // print sensor output

  if(total > 70) {
    for(int i=0; i<20; i++) {
      digitalWrite(ledPin, HIGH);
      delayMicroseconds(150);
    }
  }
  if(total > 70) {  
    for(int i=0; i<12; i++) {
      digitalWrite(ledPin, LOW);
      delayMicroseconds(150);
    }
  }
}






