/*   Displays images from an array based on serial data (integers)
 *   18 images (0-17) have to be loaded into the sketch by dragging 
 *   and dropping into the sketch window
 */
import processing.serial.*;
Serial myPort;
int serialGet;       // Integer variable for storing serial data
int numImages = 18;  // The number of images
int i;               // variable for counting
String conv;         // String variable for converting from numbers
PImage[] hands = new PImage[numImages]; // array for storing images
int selectImage;

void setup() {
  background(255);
  size(1000, 700);
  myPort = new Serial(this, Serial.list()[0], 9600);
  for(i = 0; i < numImages; i++){
   conv = Integer.toString(i);                   // Convert the number into a string
  hands[i]  = loadImage("hand" + conv + ".jpg"); // make strings into a filename
  }
} 
 
void draw() 
{ 
  while(myPort.available() > 0){
   serialGet = myPort.read();
//  println(serialGet);                                // print serial data to output window
   selectImage = int(map(serialGet, 239, 254, 0, 17)); // Scale the data to number of images
   if(selectImage < 0) { selectImage = 0; }
   println(selectImage);
   image(hands[selectImage], 0, 0, 1000, 700);  // Draw the image on the screen
  }
}
