// Processing code:
//-------------------
// analog_Resizing_Image
// -Reads analog data (numbers, not ASCII) from the serial port
// and uses data to change 2D graphic image.

import processing.serial.*;
Serial myPort;      // Create object from Serial class
String serialString;
float val;        // val for data from serial port
PImage img;  // Declare variable "a" of type PImage

void setup() {
   size(600, 600);
   
  img = loadImage("factory_workers.jpg");  // Load the image into the program  
   // Open connection to USB (COM port) at 9600 bps
    myPort = new Serial(this, Serial.list()[2], 9600); // Mac
}

void draw() {     
    println(val);
    rect(0, 0, width, height);     // rectangle covers screen 
    fill(255,255,225);             // mix RGB color for ellipse
      image(img, 0, 0, val*2, height);
  }
  
  //---- The SerialEvent function runs continuously in the background and
//---- stores new values whenever new data comes in on the serial port (USB)

void serialEvent(Serial myPort) {
   serialString = myPort.readStringUntil(10); // Read until end of line character
   if (serialString != null) {
     serialString = trim(serialString); 
     val = int(serialString);
     println(val);
   }                               // end if
}