/****************************************************
 * oscP5sendreceive by andreas schlegel
 * example shows how to send and receive osc messages.
 * oscP5 website at http://www.sojamo.de/oscP5
 * Expecting OSC data from TouchOSC "beatmachine" interface
 */
 
import oscP5.*;
import netP5.*;
 //-------------- Global Variables defined at top -------------
String oscRec;  //-- Create variable for notifications from OSC
float oscvalueF; //-- floating point data from OSC
PImage singer1; //-- Create variable of type "PImage"
PImage singer2;

OscP5 oscP5;    //-- Create software object of type "OscP5"

void setup() {
  /* start oscP5, listening for incoming messages at port 8100 */
  oscP5 = new OscP5(this,8100);  //-- Create instance of OscP5 object
  
  size(470,700);   //-- Create canvas 470 x 700 pixels
  frameRate(25);
  singer1 = loadImage("billie.jpg"); //-- Load image into "singer1" buffer
  singer2 = loadImage("judy.jpg");   //-- Load image into "singer2" buffer
}

void draw() { 
    if(oscRec == "billie") {
   image(singer1, 0, 0 );
    } else if (oscRec == "judy") {
   image(singer2, 0, 0 );
    } else {
      background(oscvalueF * 200);
    }
}


void oscEvent(OscMessage theOscMessage) {
  /* check if theOscMessage has the address pattern we are looking for. */
  /* print the address pattern and the typetag of the received OscMessage */
  print("### received an osc message. - ");
  print(" addrpattern: "+ theOscMessage.addrPattern());
  println(" typetag: "+ theOscMessage.typetag()); 
  oscvalueF = theOscMessage.get(0).intValue();
  println(oscvalueF);
//-- Expecting addrPattern sent from TouchOSC "beatmachine" layout.
  if(theOscMessage.checkAddrPattern("/syntien/basic/1/button5")==true) {
    oscRec = "billie";
  } else if(theOscMessage.checkAddrPattern("/syntien/basic/1/button6")==true) {
    oscRec ="judy";
  } else {
    oscRec = "Something else.";
  }
}
