/****************************************************
 * oscP5sendreceive by andreas schlegel
 * example shows how to send and receive osc messages.
 * oscP5 website at http://www.sojamo.de/oscP5
 */
import oscP5.*;
import netP5.*;
//-------------- Global Variables defined at top --------------------
String messg; //-- Create string variable for notifications from OSC
int oscValue; //-- Create integer variable for data in osc Message
OscP5 oscP5;  //-- Create instance of OscP5 software object

float firstValue, secondValue, thirdValue, fourthValue;
int fifthValue, sixthValue;

void setup() {
  size(400, 400);
  frameRate(25);
  /* start oscP5, listening for incoming messages at port 8100 */
  oscP5 = new OscP5(this, 8100); //-- Create instance of OscP5 called "oscP5"
}

void draw() { 
  if (messg == "true") {
    background(firstValue*255, secondValue*255, 50);
  } else {
    background(0);
  }
}


/* incoming osc message are forwarded to the oscEvent method. */
void oscEvent(OscMessage theOscMessage) {
  // check to see if we have the correct controller: XY slider on "Basic"
  if (theOscMessage.checkAddrPattern("/syntien/basic/1/touchpad1/press")==true) {
    messg = "true";
    firstValue = theOscMessage.get(0).floatValue();   // x value in xy-slider
    secondValue = theOscMessage.get(1).floatValue();  // x value in xy-slider
    sixthValue = theOscMessage.get(5).intValue();   // how many presses
    println("x = " + firstValue, "    y = " + secondValue + "    presses =  " + sixthValue);
  } else {
    messg = "Something else.";
  }
  /* print the address pattern and the typetag of the received OscMessage */
  print("### received osc message.");
  print(" address pattern: "+theOscMessage.addrPattern());
  println(" typetag: "+theOscMessage.typetag());
  //firstValue = theOscMessage.get(0).floatValue();
  //secondValue = theOscMessage.get(1).floatValue();
  //thirdValue = theOscMessage.get(2).floatValue(); 
  //fourthValue = theOscMessage.get(3).floatValue();  
  //fifthValue = theOscMessage.get(4).intValue();
  //sixthValue = theOscMessage.get(5).intValue();

  //println(firstValue, secondValue, thirdValue, fourthValue, fifthValue, sixthValue);
}
