/**
 * oscP5sendreceive by andreas schlegel
 * example shows how to send and receive osc messages.
 * oscP5 website at http://www.sojamo.de/oscP5
 */
import oscP5.*;
import netP5.*;
//-------------- Global Variables defined at top --------------------
OscP5 oscP5;                 //-- Import/Create software object "OscP5"
NetAddress myRemoteLocation; //-- Create variable of type "NetAddress"
  
void setup() {
  size(255,255); //-- Create canvas 255 x 255 pixels in size
  frameRate(25); 
 /* myRemoteLocation is a NetAddress. a NetAddress takes 2 parameters,
 * an ip address and a port number. myRemoteLocation is used as parameter in
 * oscP5.send() when sending osc packets to another computer, device, 
 * application. 
 */
myRemoteLocation = new NetAddress("127.0.0.1", 8100); //--127.0.0.1 = this machine

/* start oscP5, listening for incoming messages at port 12000 */
  oscP5 = new OscP5(this, 8100); //--Create instance of OscP5 object
}

void draw() {
      background(0);
}

void mousePressed() {
  /* in the following different ways of creating osc messages are shown by example */
  OscMessage myMessage = new OscMessage("/test");
  myMessage.add(mouseX); /* add an int to the osc message */
  /* send the message */
  oscP5.send(myMessage, myRemoteLocation);
  println("Clicked the mouse, sent OSC data to port 8100!");
}
