/* -------------------------      Analog Start     -----------------------
 *
 *   Hardware Setup- a voltage divider connected to analog pin A5:
 *   1) -Wire a photoresister between +5vdc and an empty row on the breadboard
 *   2) -Wire a 10k resistor between that same row on the breadboard to ground.
 *   3) -Jumper wire from that same row to the last pin on the chip (analog 5)
 *
 *   -Note: This sketch introduces the map() function for scaling values
 *-------------------------------------------------------------------------*/
int a_in;               // create variable for storing analog readings
int sensorPin = A5;      // variable for analog pin as A5

void setup() {
  Serial.begin(9600);            // start serial port at 9600 bps:
}

void loop() {
  // read sensor, store in variable, print
  a_in = analogRead(sensorPin);       // get 10 bit analog value
  a_in = map(a_in, 0, 1023, 0, 255);  // scale it to 8 bits
  Serial.println(a_in);
}
