// ------ Reads the state of a switch and lights an LED and beeps ---------------------
//       -Uses custom "bleep()" function
//
//  > Wire an LED from Digital Pin 7 thru 330 ohm resistor to gnd
//  > Wire a switch between Digital Pin 5 and gnd
//  > Wire a piezo between Digital Pin 6 and gnd
//---------------------------------------------------------------------------------------
boolean buttonState = 0;        // create variable for storing "state" of the button
int ledPin = 7;             // create variable for LED pin number
int buttonPin = 5;          // create variable for button pin number
int speakerPin = 6;

void setup() {                      // Only do once at startup           
  pinMode(ledPin, OUTPUT);          // initialize the digital pin as an output (for LED.)
  pinMode(buttonPin, INPUT_PULLUP); // initialize the digital pin as an input (for switch.)
  pinMode(speakerPin, OUTPUT);      // Define Speaker pin as Output (for piezo)
}
void loop()  {                          // repeat forever  
  buttonState = digitalRead(buttonPin); // "Read" the voltage present on the pin (check switch.)
  
 // If the pin wired to the button is low, the switch is closed
  if (buttonState == LOW) {     
      beep();
  } 
   // Otherwise, assume the switch is open.
  else {
    digitalWrite(ledPin, LOW);              // turn LED off:
  }
}

void beep() {
    digitalWrite(ledPin, HIGH);             // turn LED on: 
     for(int i = 0; i < 300; i++)  // number of vibrations (duration)
      {
      digitalWrite(speakerPin, HIGH);   // speaker Pin high
      delayMicroseconds(700);          // delay before releasing speaker
      digitalWrite(speakerPin, LOW);    // speaker Pin low 
      delayMicroseconds(700);
     } 
}
