
/* ----------------- analog_Light_Sensor_to_Sound (Theremin) ---------------
 *
 *   Hardware Setup- a voltage divider connected to analog 5 
 *   1) -Wire a photoresister between +5vdc and an empty row on the breadboard
 *   2) -Wire a 10k resistor between that same row on the breadboard to ground.
 *   3) -Jumper wire from that same row to the last pin on the chip (analog 5)
 *   4) -Wire a piezo disk to pin 6
 *
 *-------------------------------------------------------------------------*/

int a_in;               // create variable for storing analog readings
int sensorPin = A5;     // variable for analog pin as A5 
int piezoPin = 6;

void setup() {
  pinMode(piezoPin, OUTPUT);       // Set the digital LED pin as an output
}

void loop() {
  a_in = analogRead(sensorPin);       // get 10 bit analog value
  a_in = map(a_in, 0, 1023, 10, 800); // scale it 10 - 800 (arbitrary)
  tone(piezoPin, a_in, 100);          // play tone                    
}
