
//------------------- speaker_w_function.c ---------------------
//    ----- Plays a pitch thru a speaker and lights an LED -----
//                   Makes use of a custom function.
//- Set up: > Attach a piezo speaker between ground and D6
//          > Wire an LED from D7 thru a 330 ohm resistor to gnd

int ledPin = 7;
int piezoPin = 6;

void setup(){
   pinMode(piezoPin, OUTPUT);     // Define Speaker pin as output
   pinMode(ledPin, OUTPUT);       // Define LED pin as output 
  }                               // end setup
  
 void loop() {
   digitalWrite(ledPin, HIGH);    // Turn on LED
   play_pitch(1200);              // Run the function defined below
   digitalWrite(ledPin, LOW);     // Turn off LED
   delay(700);                    // wait 1 sec (1000 milliseconds)

   digitalWrite(ledPin, HIGH);    // Turn on LED
   play_pitch(440);               // Run the function defined below
   digitalWrite(ledPin, LOW);     // Turn off LED
   delay(700);                    // wait 1 sec (1000 milliseconds)
} 

//---- Here we define a function called "play_pitch()" 
void play_pitch(int deltime){       // Define a function called 
   for(int i = 0; i < 300; i++)     // number of vibrations (duration)
      {
      digitalWrite(piezoPin, HIGH); // speaker Pin high
      delayMicroseconds(deltime);   // delay before releasing speaker
      digitalWrite(piezoPin, LOW);  // speaker Pin low 
      delayMicroseconds(deltime);
     } 
   }                                // end function definition
