/*
 * Decompiled with CFR 0.152.
 */
package netP5;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import netP5.Logger;
import netP5.NetAddress;

public abstract class AbstractUdpClient {
    protected NetAddress _myNetAddress;
    protected DatagramSocket _mySocket;
    protected boolean isRunning = false;

    public AbstractUdpClient() {
        this.isRunning = this.openSocket();
    }

    public AbstractUdpClient(String string, int n) {
        this._myNetAddress = new NetAddress(string, n);
        if (!this._myNetAddress.isvalid()) {
            Logger.printError("UdpClient", "unknown host " + string);
        }
        this.isRunning = this.openSocket();
    }

    public DatagramSocket socket() {
        return this._mySocket;
    }

    private boolean openSocket() {
        try {
            this._mySocket = new DatagramSocket();
        }
        catch (SocketException socketException) {
            Logger.printError("UdpClient.openSocket", "cant create socket " + socketException.getMessage());
            return false;
        }
        Logger.printProcess("UdpClient.openSocket", "udp socket initialized.");
        return true;
    }

    public void send(String string) {
        this.send(string.getBytes());
    }

    public void send(byte[] byArray) {
        if (this._myNetAddress.isvalid()) {
            this.send(byArray, this._myNetAddress);
        } else {
            Logger.printWarning("UdpClient.send", "no InetAddress and port has been set. Packet has not been sent.");
        }
    }

    public void send(byte[] byArray, NetAddress netAddress) {
        if (this._myNetAddress.isvalid()) {
            this.send(byArray, netAddress.inetaddress(), netAddress.port());
        }
    }

    public void send(byte[] byArray, String string, int n) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            this.send(byArray, inetAddress, n);
        }
        catch (UnknownHostException unknownHostException) {
            Logger.printError("UdpClient.send", "while sending to " + string + " " + unknownHostException);
        }
    }

    public void send(DatagramPacket datagramPacket) {
        if (this.isRunning) {
            try {
                this._mySocket.send(datagramPacket);
            }
            catch (IOException iOException) {
                Logger.printError("UdpClient.send", "ioexception while sending packet.");
            }
        }
    }

    public void send(byte[] byArray, InetAddress inetAddress, int n) {
        if (this.isRunning) {
            try {
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
                this.send(datagramPacket);
            }
            catch (NullPointerException nullPointerException) {
                Logger.printError("UdpClient.send", "a nullpointer exception occured." + nullPointerException);
            }
        } else {
            Logger.printWarning("UdpClient.send", "DatagramSocket is not running. Packet has not been sent.");
        }
    }
}

