
//---------------------------------------------------------------------
//    Serial_Send_Analog
//     Demonstrates sending data (numbers) to the serial port
//---------------------------------------------------------------------
/*   Hardware Setup- a voltage divider connected to analog 5  (Pin 28):
     1) -Wire a photoresister between +5vdc and an empty row on the breadboard
     2) -Wire a 10k resistor between that same row on the breadboard to ground.
     3) -Jumper wire from that same row to the last pin on the chip (analog 5)
     4) -Wire an LED thru a 330 ohm resistor from digital pin 7 (pin 13) to gnd

  -------------------------------------------------------------------------*/


int analogPin = A5;             // Variable for which analog pin to read
int LEDpin = 7;                 // Variable for which pin for LED
int analogValue;                // Variable for storing analog readings

void setup() {
  Serial.begin(9600);           // start serial port at 9600 bps
  pinMode(LEDpin, OUTPUT);      // sets pin  as output
}

void loop() {
  // read digital input, remap 10-bit value to 8-bit
  analogValue = analogRead(analogPin);
  analogValue = map(analogValue, 0, 1023, 0, 255);

  if (analogValue < 210) {             // If light level is below  180
    digitalWrite(LEDpin, HIGH);          // Turn on LED
  } else {
    digitalWrite(LEDpin, LOW);
  }
   //Serial.println(analogValue);     // Send analogValue to serial (USB) as ASCII for Serial Monitor
  Serial.write(analogValue);          // Send analogValue to serial (USB) as BYTE for multimedia sopftware
  delay(20);                          // pause for 10 milliseconds
}

