/* Processing code:
 * Example of using a scaled value or the mouseX 
 * to select index numbers in an array of images
 *--------------------------------------------------------------*/

 int mappedMouse;                          // variable for data scaled to number of images
 int numFrames = 4;                        // The number of frames in the animation
 PImage[] images = new PImage[numFrames];  // creates array PImages
 String[] seasons = { "winter.jpg", "fall.jpg", "spring.jpg", "summer.jpg" };  // Alternate array syntax

  void setup() {
    size(400, 600);
    tint(255, 255, 255, 10);   // Alpha transparency 10
    for (int i = 0; i < numFrames; i++) {
      images[i] = loadImage(seasons[i]);
       }
   } 
 
// scales mouseX, draws image with transparency on canvas:

  void draw() {  
    mappedMouse = int(map(mouseX, 0, 320, 0, 3)); //-- map data to # of images in array
    println(mappedMouse);
    image(images[mappedMouse], 0, 0);
}