//------------------------------------------------------
//  Example of a Custom Function (we'll call "blinkLED")
//  - Setup: 
//    Wire an LED from pin 7 thru a resistor to GND
//------------------------------------------------------

int ledPin = 7;

void setup() {
  pinMode(ledPin, OUTPUT);
}

void loop()  {
   blinkLED(5, 200);   //- 5 times at 100 milliseconds
   delay(500); 
   blinkLED(3, 600);   //- 3 times at 600 milliseconds
   delay(500); 
}


//--- This is the custom function:

void blinkLED(int times, int delayTime) {
  for(int i = 0; i < times; i++) {
      digitalWrite(ledPin, HIGH); // blink LED quickly
      delay(delayTime);                 // (100 milliseconds)
      digitalWrite(ledPin, LOW);
      delay(delayTime);
   }   //-- (end of for() loop)
}    //-- (end of function definition)
