// ------ Reads the state of a switch and lights an LED accordingly ---
//       -Using variables to store pin numbers
//
//  > Wire an LED from Pin 7 thru 330 ohm resistor to GND
//  > Wire a switch between Digital Pin 5  and GND
//---------------------------------------------------------------------

boolean buttonState = 0;    // create variable for storing "state" of the button
int ledPin = 7;             // create variable for LED pin number
int buttonPin = 5;          // create variable for button pin number

void setup() {                      // Only do once at startup           
  pinMode(ledPin, OUTPUT);          // initialize the digital pin as an output (for LED.)
  pinMode(buttonPin, INPUT_PULLUP); // initialize the digital pin as an input (for switch.)
}
void loop()  {                          // repeat forever  
  buttonState = digitalRead(buttonPin); // "Read" the voltage present on the pin (check switch.)
  
 // If the pin wired to the button is low, the switch is closed
  if (buttonState == LOW) {     
    digitalWrite(ledPin, HIGH);             // turn LED on: 
  } 
   // Otherwise, assume the switch is open.
  else {
    digitalWrite(ledPin, LOW);              // turn LED off:
  }
}
