//------------------- piezo_random_freq w switch---------------------
//---  Plays a pitch thru a piezo speaker
//- Set up: > Attach a piezo speaker between ground and Digital 6 (pin 12)
//          > Wire a switch between pin 5 (physical pin 11) and Gnd
//  
int piezoPin = 6;      // variable for which pin is attached to piezo
int buttonPin = 5;     // which pin is attached to the switch
boolean switchState;   // boolean (HIGH or LOW) variable for state of switch
int rand_freq;         // variable for storing random frequency
   
void setup(){
  pinMode(buttonPin, INPUT_PULLUP); // enable "pullup resistor"  
  pinMode(piezoPin, OUTPUT);        // Set the digital LED pin as an output
  }   
          
void loop(){
    switchState = digitalRead(buttonPin); // Check the state of button
    if(switchState == LOW) {              // Switch is closed if connected to Ground
    rand_freq = random(600, 1200);        // Random pitch between 600 and 1200
    tone(piezoPin, rand_freq, 100);       // duration of 100 (arbitrarily short)
    delay(60);
    } else {                              // Else, switch is open. "Tied high"
          rand_freq = random(60, 600);    // Random pitch between 60 and 600
    tone(piezoPin, rand_freq, 600);       // Duration is 600
    delay(300);
    }
}
