
//------------------- piezo_random_tone w switch---------------------
//---  Plays a random tone from an array thru a piezo speaker
//- Set up: > Attach a piezo speaker between ground and Digital pin 6
//          > Wire a switch between pin 5 and Gnd
//  
int piezoPin = 6;      // variable for which pin is attached to piezo
int buttonPin = 5;     // which pin is attached to the switch
boolean switchState;   // boolean (HIGH or LOW) variable for state of switch
int randTone;          // variable for storing random tone      

int Tones[]={294, 330, 349, 392, 440, 490, 525}; // 7 item array


void setup(){
  pinMode(buttonPin, INPUT_PULLUP); // enable "pullup resistor"  
  pinMode(piezoPin, OUTPUT);        // Set the digital LED pin as an output
  }   
          
void loop(){
    randTone = Tones[random(0, 7)];       // Pick a random pitch between 0 and 6
    switchState = digitalRead(buttonPin); // Check the state of button
    if(switchState == LOW) {              // Switch is closed if connected to Ground
    tone(piezoPin, randTone, 100);        // short duration (100) 
    delay(120);
    } else {                              // Else, switch is open. "Tied high"
    tone(piezoPin, randTone, 100);        //  
    delay(300);                           // Longer delay between tones
    }
}
