/* -------------------   analog_Light_Sensor_to_Sound (pitch) ---------------
 *
 *   Hardware Setup- a voltage divider connected to analog pin A5:
 *   1) -Wire a photoresister between +5vdc and an empty row on the breadboard
 *   2) -Wire a 10k resistor between that same row on the breadboard to ground.
 *   3) -Jumper wire from that same row to the last pin on the chip (analog 5)
 *   4) -Wire a piezo disk to pin 6
 *
 *-------------------------------------------------------------------------*/

int a_in;               // create variable for storing analog readings
int sensorPin = A5;      // variable for analog pin as A5
int piezoPin = 6;
int numTones = 10;
int tones[] = {261, 277, 294, 311, 330, 349, 370, 392, 415, 440};
//         mid  C    C#    D  D#    E    F   F#    G    G#   A

void setup() {
  pinMode(piezoPin, OUTPUT);       // Set the digital LED pin as an output
}

void loop() {
  a_in = analogRead(sensorPin);       // get 10 bit analog value
  a_in = map(a_in, 0, 1023, 0, 9);    // scale it 0 - 9
  tone(piezoPin, tones[a_in], 500);   // play tone in array                    
}
