
/* Processing code:
 *
 * Text display on screen of data sent to the serial port.
 * (Font created and integers translated to ASCII for display)
 *--------------------------------------------------------------*/
 import processing.serial.*;
 Serial myPort;
 PFont f;                  // font object (for graphical text)
 int serialGet;            // Integer variable for storing serial data
 String serialString;      // String variable for drawing alphanumerics
 int val;               // variable for string cast as integer
 
  void setup() {
  size(350, 200);
  background(200, 210, 0);   // color (r, g, b)
  printArray(Serial.list());   // -Gives list of available ports   
  myPort = new Serial(this, Serial.list()[1], 9600); //-- Change to your port number


  smooth();
  //-----  Create graphical font -------
  //printArray(PFont.list());
  f = createFont("Verdana", 42);
  textFont(f);
  textAlign(CENTER);
  fill(90, 100);             // Set the gray value and alpha of graphics 
  } 
 
//--Here the draw loop uses serialGet variable fetched by serialEvent()
 
  void draw() {  
    background(200, 210, 0);        // clear the screen
    rect(50, 50, val, 50);       // draw rectangle: upper Lt x, y, Lower Rt x, y
    text(str(val), 170, 140);   // draw text (serialString) on the screen at x, y
 }             

//---- The SerialEvent function runs continuously in the background and
//---- stores new values whenever new data comes in on the serial port (USB) 
void serialEvent(Serial myPort) {
   serialString = myPort.readStringUntil(10); // Read until end of line character
   if (serialString != null) {
     serialString = trim(serialString); 
     val = int(serialString);              // cast ASCII values as a number
     println(serialString);
   }                                          // end if
}
