// ----  Random Dispersal example for OSCON by Dana Moser
//      (Creates and animates "brownian noise" oscillating ellipses)
// ----  This code is in the public domain.

int howMany = 300;
float mouseRed;
float mouseBlue;
float mouseRadius;

float[] x = new float[howMany];       // Create arrays for x, y
float[] y = new float[howMany];

void setup() {
  size(900, 600);                 // Creates a 900x600 pixel window

  for (int i=0; i < howMany; i=i+1) {
    x[i] = random(430, 480);      //--Load in initial location for each
    y[i] = random(290, 310);
   }
}

void draw() {
  background(0);    // Cover background with black
  mouseRed = map(mouseX, 0, 900, 0, 255);
  mouseBlue = map(mouseY, 0, 600, 0, 255);
  mouseRadius = map(mouseX, 0, 900, 15, 100);
  fill(mouseRed, 255, mouseBlue, 40);  // (R, G, B and Alpha)
  if(mouseX > 450){
  stroke(180, 0, 0, 200);    //- Stroke R, G, B, Alpha
  strokeWeight(mouseX * .002);
  } else {
  noStroke();
  }
  
  for (int i=0; i < howMany; i=i+1) {  //---for each element

    x[i] = x[i] + random(-2,2);        //--- move
    y[i] = y[i] + random(-2,2);

    ellipse(x[i], y[i], mouseRadius, mouseRadius); //--- draw ellipse x, y
  }
}
