// ------ Reads the state of a switch and lights an LED accordingly ---
//       -Using variables to store pin numbers
//
//  > Wire an LED from Pin 7 thru 330 ohm resistor to GND
//  > Wire a switch between Digital Pin 5  and GND
//---------------------------------------------------------------------

boolean buttonState = 0;    // variable for "state" of the button
int ledPin = 7;             // variable for LED pin number
int buttonPin = 5;          // variable for button pin number

void setup() {                               
  pinMode(ledPin, OUTPUT);          // set digital pin as output (for LED.)
  pinMode(buttonPin, INPUT_PULLUP); // set digital pin as input (for switch.)
}
void loop()  {                           
  buttonState = digitalRead(buttonPin); // "Read" voltage present on pin
  
 //-- If the pin wired to the button is low, the switch is closed
  if (buttonState == LOW) {  
    timedBlink(150);
  } 
   // Otherwise, assume the switch is open.
  else {
    timedBlink(500);
  }
}

void timedBlink(int delayTime) {
    digitalWrite(ledPin, HIGH);             // blink LED: 
    delay(delayTime);
    digitalWrite(ledPin,LOW);       
    delay(delayTime);
}
