
/* ----------------- analog_Light_Sensor_to_Sound (Theremin) ---------------
 *
 *   Hardware Setup- a voltage divider connected to analog 5 
 *   1) -Wire a photoresister between +5vdc and an empty row on the breadboard
 *   2) -Wire a 10k resistor between that same row on the breadboard to ground.
 *   3) -Jumper wire from that same row to the A5 analog pin
  *     - Note: you can also use a solar cell which generates an actual voltage
          In that case: - wire goes to ground, + goes to Arduino pin A5
          and you don't need the 10K resistor.
 *
 *   4) -Wire a piezo disk to pin 6 and ground

     Taming the sensor:
     1. run code and look closely at a_in in Serial Monitor
     2. you want to determine the highest and lowest values reported
         by the sensor for your given conditions
     3. set values for lowin and highIn accordingly; 
         you may want to go a bit below and a bit above your observed values
     4. set output values as desired for the effect you want

 *-------------------------------------------------------------------------*/

int a_in;               // create variable for storing analog readings
int sensorPin = A5;     // variable for analog pin as A5
int piezoPin = 6;       // variable for piezo pin on Arduino Pin 6
int noteDuration = 50;  // variable for note duration - play with this

// variables for scaling data
int a_scaled;
int lowIn = 20;
int highIn = 125;
int lowOut = 10;
int highOut = 880;

void setup() {
  pinMode(piezoPin, OUTPUT);  // Set the piezo pin as an output
  Serial.begin(9600);
}

void loop() {
  a_in = analogRead(sensorPin);                                // get 10 bit analog value (0-1023)
  a_scaled = constrain(a_in, lowIn, highIn);                   // force it to be between hi & lo values
  a_scaled = int(map(a_in, lowIn, highIn, lowOut, highOut));   // scale it to range we want (arbitrary)

  Serial.print(a_in);
  Serial.print("   ");
  Serial.println(a_scaled);

  tone(piezoPin, a_in, noteDuration);  // play tone
}
