/*------------------------------------------------------------------------
                              Sound Example              
 Uses the Processing Sound Library. Four graphical buttons respond to 
keypresses on the letters "a" "s" "d" "f" and "g". The first four play
samples. the last key, "g" just clears the tinting on the last key played.
-----------------------------------------------------------------------*/

import processing.sound.*;
SoundFile gButt; //--- Four objects of type "SoundFile" are created
SoundFile rButt;
SoundFile bButt;
SoundFile yButt;
PImage blue_btn; 
PImage red_btn;
PImage green_btn;
PImage yellow_btn;

String playWhich;

void setup() {
 size(850,600);
 fill(0,50,90);
  bButt = new SoundFile(this, "singing.wav"); // Load samples into our sound objects
  rButt = new SoundFile(this, "chord.wav");
  gButt = new SoundFile(this, "morning.wav");
  yButt = new SoundFile(this, "pow.wav");
  
  green_btn = loadImage("green_btn.png");     // Load images into our image objects
  red_btn = loadImage("red_btn.png"); 
  blue_btn = loadImage("blue_btn.png");
  yellow_btn = loadImage("yellow_btn.png"); 
  imageMode(CENTER);
}

void draw() {
    rect(0, 0, width, height);             // rectangle covers (clears) screen 
      clearButtons();    
     if(playWhich == "blue") {
         tint(150, 150, 150);
         image(blue_btn, 200, (height/2), 100, 100);
        } else if(playWhich == "red") {
         tint(150, 150, 150); 
         image(red_btn, 350, (height/2), 100, 100);
        } else if(playWhich == "green") {
         tint(150, 150, 150);
         image(green_btn, 500, (height/2), 100, 100);
        } else if(playWhich == "yellow") {
         tint(150, 150, 150);
         image(yellow_btn, 650, (height/2), 100, 100);
        }
        else if(playWhich == "clear") {
          clearButtons();
        }
}

void keyPressed() {
  switch(key){
  case 'a':        // blue
   playWhich = "blue";
    bButt.stop();
    bButt.play();
    break;
  case 's':        // red
    playWhich = "red";
    rButt.stop();
    rButt.play();
    break;
  case 'd':        // green
    playWhich = "green";
    gButt.stop();
    gButt.play();
    break;
  case 'f':        // yellow
    playWhich = "yellow";
    yButt.stop();
    yButt.play();
    break;
    case 'g':        // clear
    playWhich = "clear";
    break;
  }
}

void clearButtons() {
     noTint();
     image(blue_btn, 200, (height/2), 100, 100); 
     image(red_btn, 350, (height/2), 100, 100);
     image(green_btn, 500, (height/2), 100, 100);
     image(yellow_btn, 650, (height/2), 100, 100);
}
