/**
 * Gets Serial data and uses it to scale widths and 
 * heights of displayed images
 * 
 */
 import processing.serial.*;
 Serial myPort;
 int val;
 String serialString;
 
PImage img_bk;  // Declare variable of type PImage
PImage eye; 
PImage nose;  
PImage mouth;  
int mouseNose, mouseEye, mouseMouth;

void setup() {
  size(900, 672);
  // image file must be in the data folder of the current sketch 
  // to load successfully
  img_bk = loadImage("pino_bkg.png");  // Load the image 
  eye = loadImage("eye.png");  // Load the image 
  nose = loadImage("nose.png");  // Load the image 
  mouth = loadImage("mouth.png");  // Load the image 
  printArray(Serial.list());   // Diagnostic: gives list of ports
  myPort = new Serial(this, Serial.list()[0], 9600); //-- Change to your port number
}

void draw() {
//-------- Draw images: ----------------  
  image(img_bk, 0, 0);       //---- Draw the background
 imageMode(CENTER);
 mouseEye = int(map(val, 0, 255, 150, 170));
 image(eye, 420, 345, 83, mouseEye);
 imageMode(CORNER);
 mouseNose = int(map(val, 0, 255, 100, 370));
 image(nose, 460, 380, mouseNose, 103);
  mouseMouth = int(map(val, 0, 255, 35, 72));
 image(mouth, 428, 490, 79, mouseMouth);
}                                    


//---- The SerialEvent function runs continuously in the background and
//---- stores new values whenever new data comes in on the serial port (USB)
void serialEvent(Serial myPort) {   
  serialString = myPort.readStringUntil(10); // Read until end of line character
  if (serialString != null) {     
    serialString = trim(serialString);      
    val = int(serialString);
//    val = 255 - val;
//    println(val);               // Uncomment this line once you know your port
  }             //- end if()
}                             //- end function definition
