// Processing code:
//-------------------
// Image interaction with data from the serial port
//------------------------------------------------

PImage balloon_img, face_img;   // Declare variables of type: PImage

//--------------- Below are variable added for Serial support ------
import processing.serial.*;
Serial myPort;        // Create object from Serial class
String serialString;  // variable for serial ASCII date
float val;            // val for data from serial port
//------------------------------------------------------------------

void setup() {
   size(600, 600);                            // set fill color to black  
   balloon_img = loadImage("balloons.png");  // Load the image into the program 
   face_img = loadImage("danaFace.png");     // Load the image into the program  
   imageMode(CENTER);                        // draw point is center of image

//--------------- Below is added to setup for Serial support ------
 // Open connection to USB (COM port) at 9600 bps
   printArray(Serial.list());   // -Gives list of available ports   
   myPort = new Serial(this, Serial.list()[0], 9600); //-- Change to your port number
//------------------------------------------------------------------
}

void draw() {    
    image(balloon_img, (width/2), (height/2), width, height);  
    //---- then draw face image:
    // Change the following line to interact with the variable "val":
    image(face_img, (width / 2), (height / 2), 250, 350);  //-- x, y, width, height
}

//---- The SerialEvent function runs continuously in the background and
//---- stores new values whenever new data comes in on the serial port (USB)

void serialEvent(Serial myPort) {
   serialString = myPort.readStringUntil(10); // Read until end of line character
   if (serialString != null) {
     serialString = trim(serialString); 
     val = int(serialString);
//     println(val);
   }                               // end if
}
