// ----  Analog_plus_keypress
//     Demonstrates interaction of analog sensor and keypress
// ----  This code is in the public domain.
import processing.serial.*;
Serial myPort;        // Create object from Serial class
String serialString;  // variable for serial ASCII date
float val;            // val for data from serial port

float xLoc = 450;
float yLoc = 300;
float randMove;
int r = 100;          // variables for red, green and blue
int g = 100;
int b = 100;

void setup() {
  size(900, 600);                 // Creates a 900x600 pixel window
  fill(230, 255, 235, 150);  // (R, G, B and Alpha)
  noStroke();
// Open connection to USB (COM port) at 9600 bps
   printArray(Serial.list());                           // -Gives list of available ports 
//------- Open connection to USB (COM port) at 9600 bps 
   myPort = new Serial(this, Serial.list()[0], 9600); //-- Change to your port number
}

void draw() {
  fill(0, 0, 0, 8);    
  rect(0, 0, width, height);    // cover background with tansparent rect
  xLoc = xLoc + random(-2,2);
  yLoc = yLoc + random(-2,2);
  fill(r, g, b);
  ellipse(xLoc, yLoc, val, val);       //--- draw ellipse x, y
  }

void keyPressed()  {
       if (key == 49) {           // Key code for the "1" key
           r = 255;               // set colors
           g = 0;
           b = 0;
         println("Using Red.");
        } else if (key == 50) {   // Key code for the "2" key
           r = 0;               // set colors
           g = 255;
           b = 0;               
         println("Using Green.");
       }else if (key == 51) {   // Key code for the "3" key
           r = 0;               // set colors
           g = 0;
           b = 255;
         println("Using Blue.");
       }
}
//---- The SerialEvent function runs continuously in the background and
//---- stores new values whenever new data comes in on the serial port (USB)

void serialEvent(Serial myPort) {
   serialString = myPort.readStringUntil(10); // Read until end of line character
   if (serialString != null) {
     serialString = trim(serialString); 
     val = int(serialString);
//     println(val);
   }                               // end if
}
