/* Processing code:
 * Example of animation using the mouse X-axis location 
 * to select index numbers in an array of images
 *--------------------------------------------------------------*/
 
 int mappedVar;           // Variable for scaled (mapped) value
 int numFrames = 13;      // The number of frames in the animation
 PImage[] images = new PImage[numFrames];

  void setup() {
    frameRate(30);
    size(793, 598);
    background(0, 0, 0);   // color (r, g, b)
    // The nf() command does number formatting, which will
    // ensure that the number is (in this case) 2 digits.
    for (int i = 0; i < numFrames; i++) {
      String imageName = "sloth" + nf(i, 2) + ".jpg";
      images[i] = loadImage(imageName);
       }
    smooth();
   } 
 
// draw listens to serial port, calls serialEvent, draws   
  void draw() {  
    background(0, 0, 0);          // clear the screen
    fill(90, 100);                    // Set the gray value and alpha of the Rectangle 
    mappedVar = int(map(mouseX, 0, 793, 0, 12));
    fill(250);                       // Set the gray value and alpha of the letters 
    image(images[mappedVar], 0, 0);
}
