/* Processing code:
 * Example of image interaction using Serial data 
 * to select index numbers in an array of images
 *--------------------------------------------------------------*/
 
 import processing.serial.*;
 Serial myPort;
 String serialGetString;  // for storing ASCII received from Ardiuino
 int serialNum;           // Integer variable for storing serial data
 int mappedSer;           // Variable for scaled (mapped) value
 int numFrames = 13;      // The number of frames in the animation
 PImage[] images = new PImage[numFrames];

  void setup() {
    frameRate(30);
    size(793, 598);
    background(0, 0, 0);   // color (r, g, b)
    // The nf() command does number formatting, which will
    // ensure that the number is (in this case) 2 digits.
    for (int i = 0; i < numFrames; i++) {
      String imageName = "sloth" + nf(i, 2) + ".jpg";
      images[i] = loadImage(imageName);
       }
    smooth();
 // Open connection to USB (COM port) at 9600 bps
   printArray(Serial.list());   // -Gives list of available ports   
   myPort = new Serial(this, Serial.list()[0], 9600); //-- Change to your port number
   } 
 
// draw listens to serial port, calls serialEvent, draws   
  void draw() {  
    background(0, 0, 0);          // clear the screen
    fill(90, 100);                    // Set the gray value and alpha of the Rectangle 
    mappedSer = int(map(serialNum, 0, 255, 0, 12));
    fill(250);                       // Set the gray value and alpha of the letters 
    image(images[mappedSer], 0, 0);
    }            

//---- The SerialEvent function runs continuously in the background and
//---- stores new values whenever new data comes in on the serial port (USB)
void serialEvent(Serial myPort) {   
  serialGetString = myPort.readStringUntil(10); // Read until end of line character
  if (serialGetString != null) {     
    serialGetString = trim(serialGetString);      
    serialNum = int(serialGetString);
//    serialNum = 255 - serialNum;  //uncomment to reverse action
    println(serialNum);
  }             //- end if()
}                             //- end function definition
