/*
 * CapitiveSense Library Demo Sketch
 * Paul Badger 2008
 * Uses a high value resistor e.g. 10M between send pin and receive pin
 * Resistor effects sensitivity, experiment with values, 50K - 50M. Larger resistor values yield larger sensor values.
 * Receive pin is the sensor pin - try different amounts of foil/metal on this pin
 * Hardware setup:
 *                 - Connect pin 4 and pin 2 through a resistor (1 - 10 Meg)
 *                - Also connect pin 2 to a metallic sheet (aluminum foil attached to clip lead)
 */

#include <CapacitiveSensor.h>
int ledPin = 6;
CapacitiveSensor   cs_4_2 = CapacitiveSensor(4,2);        // 10M resistor between pins 4 & 2, pin 2 is sensor pin

void setup()                    
{
  pinMode(ledPin, OUTPUT);   // LED
   cs_4_2.set_CS_AutocaL_Millis(0xFFFFFFFF);     // turn off autocalibrate on channel 1 - just as an example
   Serial.begin(9600);
}

void loop()                    
{
    long start = millis();
    long total1 =  cs_4_2.capacitiveSensor(30);

//    Serial.print(millis() - start);        // check on performance in milliseconds
 //   Serial.print("\t");                    // tab character for debug windown spacing

    Serial.println(total1);                  // print sensor output 1

  if(total1 > 300){
    digitalWrite(ledPin, HIGH);
  } else {
    digitalWrite(ledPin, LOW);
  }
 
    delay(10);                             // arbitrary delay to limit data to serial port 
}
