// fred 2-17-2011
// Arduino
//
// Wire digital pin 2 to digital pin 4 through 1 Meg resistor
// and to 4" x 4" sensor plate made of copper or aluminum foil.
//
// Note: we are making an RC timer with the sensor as one plate of a capacitor.
// We will time how long it takes to charge it. This will vary depending 
// on whether a person is touching it. A person is roughly a 100pF capacitor.
//

void setup()                    
{
  Serial.begin(9600);

  pinMode(2, INPUT);    // sense pin attached to plate
  digitalWrite(2, LOW); // turn off pull-up resistor
  pinMode(4, OUTPUT);   // output pin for sending 5 microsecond pulse
  pinMode(6, OUTPUT);   // LED

}

void loop()                    
{  

  int samplevalue = 0;		// zero data
  int i;
  
  for(i=0; i<8; i++) {	      // take eight samples
    digitalWrite(4, LOW);     // start low
    delay(1);		              // let it settle
    digitalWrite(4, HIGH);    // now make it go high
    delayMicroseconds(50);    // 50 us delay - test for capacitance of subject

    if(digitalRead(2) == HIGH) {  // if pin is high, no one is touching
    }
    else {                 // someone is touching - takes too long to charge plate
      samplevalue++;          // increment sample value
    }

  }  // end FOR

  if (samplevalue >= 3) {    // if greater than 3 samples indicate 'touching'
    digitalWrite(6, HIGH);
    Serial.print("samplevalue = ");
    Serial.println(samplevalue);    // print sensor output 2
  }
  else {
    digitalWrite(6, LOW);
    Serial.println("not touching");			
  }
  delay(100);    // delay before next reading
}


