/*
 * Decompiled with CFR 0.152.
 */
package TUIO;

import TUIO.TuioContainer;
import TUIO.TuioPoint;
import TUIO.TuioTime;

public class TuioObject
extends TuioContainer {
    protected int symbol_id;
    protected float angle;
    protected float rotation_speed;
    protected float rotation_accel;
    public static final int TUIO_ROTATING = 5;

    public TuioObject(TuioTime tuioTime, long l, int n, float f, float f2, float f3) {
        super(tuioTime, l, f, f2);
        this.symbol_id = n;
        this.angle = f3;
        this.rotation_speed = 0.0f;
        this.rotation_accel = 0.0f;
    }

    public TuioObject(long l, int n, float f, float f2, float f3) {
        super(l, f, f2);
        this.symbol_id = n;
        this.angle = f3;
        this.rotation_speed = 0.0f;
        this.rotation_accel = 0.0f;
    }

    public TuioObject(TuioObject tuioObject) {
        super(tuioObject);
        this.symbol_id = tuioObject.getSymbolID();
        this.angle = tuioObject.getAngle();
        this.rotation_speed = 0.0f;
        this.rotation_accel = 0.0f;
    }

    public void update(TuioTime tuioTime, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        super.update(tuioTime, f, f2, f4, f5, f7);
        this.angle = f3;
        this.rotation_speed = f6;
        this.rotation_accel = f8;
        if (this.rotation_accel != 0.0f && this.state != 3) {
            this.state = 5;
        }
    }

    public void update(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        super.update(f, f2, f4, f5, f7);
        this.angle = f3;
        this.rotation_speed = f6;
        this.rotation_accel = f8;
        if (this.rotation_accel != 0.0f && this.state != 3) {
            this.state = 5;
        }
    }

    public void update(TuioTime tuioTime, float f, float f2, float f3) {
        TuioPoint tuioPoint = (TuioPoint)this.path.lastElement();
        super.update(tuioTime, f, f2);
        TuioTime tuioTime2 = this.currentTime.subtract(tuioPoint.getTuioTime());
        float f4 = (float)tuioTime2.getTotalMilliseconds() / 1000.0f;
        float f5 = this.angle;
        float f6 = this.rotation_speed;
        this.angle = f3;
        float f7 = (this.angle - f5) / ((float)Math.PI * 2);
        if (f7 > 0.75f) {
            f7 -= 1.0f;
        } else if (f7 < -0.75f) {
            f7 += 1.0f;
        }
        this.rotation_speed = f7 / f4;
        this.rotation_accel = (this.rotation_speed - f6) / f4;
        if (this.rotation_accel != 0.0f && this.state != 3) {
            this.state = 5;
        }
    }

    public void update(TuioObject tuioObject) {
        super.update(tuioObject);
        this.angle = tuioObject.getAngle();
        this.rotation_speed = tuioObject.getRotationSpeed();
        this.rotation_accel = tuioObject.getRotationAccel();
        if (this.rotation_accel != 0.0f && this.state != 3) {
            this.state = 5;
        }
    }

    public void stop(TuioTime tuioTime) {
        this.update(tuioTime, this.xpos, this.ypos, this.angle);
    }

    public int getSymbolID() {
        return this.symbol_id;
    }

    public float getAngle() {
        return this.angle;
    }

    public float getAngleDegrees() {
        return this.angle / (float)Math.PI * 180.0f;
    }

    public float getRotationSpeed() {
        return this.rotation_speed;
    }

    public float getRotationAccel() {
        return this.rotation_accel;
    }

    public boolean isMoving() {
        return this.state == 1 || this.state == 2 || this.state == 5;
    }
}

