/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.OSCListener;
import com.illposed.osc.OSCPacket;
import com.illposed.osc.OSCPort;
import com.illposed.osc.utility.OSCByteArrayToJavaConverter;
import com.illposed.osc.utility.OSCPacketDispatcher;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;

public class OSCPortIn
extends OSCPort
implements Runnable {
    protected boolean isListening;
    protected OSCByteArrayToJavaConverter converter = new OSCByteArrayToJavaConverter();
    protected OSCPacketDispatcher dispatcher = new OSCPacketDispatcher();

    public OSCPortIn(int n) throws SocketException {
        this.socket = new DatagramSocket(n);
        this.port = n;
    }

    public void run() {
        byte[] byArray = new byte[65536];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, 65536);
        while (this.isListening) {
            try {
                datagramPacket.setLength(65536);
                this.socket.receive(datagramPacket);
                OSCPacket oSCPacket = this.converter.convert(byArray, datagramPacket.getLength());
                this.dispatcher.dispatchPacket(oSCPacket);
            }
            catch (SocketException socketException) {
                if (!this.isListening) continue;
                socketException.printStackTrace();
            }
            catch (IOException iOException) {
                if (!this.isListening) continue;
                iOException.printStackTrace();
            }
        }
    }

    public void startListening() {
        this.isListening = true;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void stopListening() {
        this.isListening = false;
    }

    public boolean isListening() {
        return this.isListening;
    }

    public void addListener(String string, OSCListener oSCListener) {
        this.dispatcher.addListener(string, oSCListener);
    }

    public void close() {
        this.socket.close();
    }
}

