/*
 * Decompiled with CFR 0.152.
 */
package TUIO;

import TUIO.TuioContainer;
import TUIO.TuioPoint;
import TUIO.TuioTime;

public class TuioBlob
extends TuioContainer {
    protected int blob_id;
    protected float angle;
    float width;
    float height;
    float area;
    protected float rotation_speed;
    protected float rotation_accel;
    public static final int TUIO_ROTATING = 5;

    TuioBlob(TuioTime tuioTime, long l, int n, float f, float f2, float f3, float f4, float f5, float f6) {
        super(tuioTime, l, f, f2);
        this.blob_id = n;
        this.angle = f3;
        this.width = f4;
        this.height = f5;
        this.area = f6;
        this.rotation_speed = 0.0f;
        this.rotation_accel = 0.0f;
    }

    public TuioBlob(long l, int n, float f, float f2, float f3, float f4, float f5, float f6) {
        super(l, f, f2);
        this.blob_id = n;
        this.angle = f3;
        this.width = f4;
        this.height = f5;
        this.area = f6;
        this.rotation_speed = 0.0f;
        this.rotation_accel = 0.0f;
    }

    public TuioBlob(TuioBlob tuioBlob) {
        super(tuioBlob);
        this.blob_id = tuioBlob.getBlobID();
        this.angle = tuioBlob.getAngle();
        this.width = tuioBlob.getWidth();
        this.height = tuioBlob.getHeight();
        this.area = tuioBlob.getArea();
        this.rotation_speed = 0.0f;
        this.rotation_accel = 0.0f;
    }

    public void update(TuioTime tuioTime, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        super.update(tuioTime, f, f2, f7, f8, f10);
        this.angle = f3;
        this.width = f4;
        this.height = f5;
        this.area = f6;
        this.rotation_speed = f9;
        this.rotation_accel = f11;
        if (this.rotation_accel != 0.0f && this.state != 3) {
            this.state = 5;
        }
    }

    public void update(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        super.update(f, f2, f7, f8, f10);
        this.angle = f3;
        this.width = f4;
        this.height = f5;
        this.area = f6;
        this.rotation_speed = f9;
        this.rotation_accel = f11;
        if (this.rotation_accel != 0.0f && this.state != 3) {
            this.state = 5;
        }
    }

    public void update(TuioTime tuioTime, float f, float f2, float f3, float f4, float f5, float f6) {
        TuioPoint tuioPoint = (TuioPoint)this.path.lastElement();
        super.update(tuioTime, f, f2);
        this.width = f4;
        this.height = f5;
        this.area = f6;
        TuioTime tuioTime2 = this.currentTime.subtract(tuioPoint.getTuioTime());
        float f7 = (float)tuioTime2.getTotalMilliseconds() / 1000.0f;
        float f8 = this.angle;
        float f9 = this.rotation_speed;
        this.angle = f3;
        float f10 = (this.angle - f8) / ((float)Math.PI * 2);
        if (f10 > 0.75f) {
            f10 -= 1.0f;
        } else if (f10 < -0.75f) {
            f10 += 1.0f;
        }
        this.rotation_speed = f10 / f7;
        this.rotation_accel = (this.rotation_speed - f9) / f7;
        if (this.rotation_accel != 0.0f && this.state != 3) {
            this.state = 5;
        }
    }

    public void update(TuioBlob tuioBlob) {
        super.update(tuioBlob);
        this.angle = tuioBlob.getAngle();
        this.width = tuioBlob.getWidth();
        this.height = tuioBlob.getHeight();
        this.area = tuioBlob.getArea();
        this.rotation_speed = tuioBlob.getRotationSpeed();
        this.rotation_accel = tuioBlob.getRotationAccel();
        if (this.rotation_accel != 0.0f && this.state != 3) {
            this.state = 5;
        }
    }

    public void stop(TuioTime tuioTime) {
        this.update(tuioTime, this.xpos, this.ypos, this.angle, this.width, this.height, this.area);
    }

    public int getBlobID() {
        return this.blob_id;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public int getScreenWidth(int n) {
        return (int)(this.width * (float)n);
    }

    public int getScreenHeight(int n) {
        return (int)(this.height * (float)n);
    }

    public float getArea() {
        return this.area;
    }

    public float getAngle() {
        return this.angle;
    }

    public float getAngleDegrees() {
        return this.angle / (float)Math.PI * 180.0f;
    }

    public float getRotationSpeed() {
        return this.rotation_speed;
    }

    public float getRotationAccel() {
        return this.rotation_accel;
    }

    public boolean isMoving() {
        return this.state == 1 || this.state == 2 || this.state == 5;
    }
}

