/*
 * Decompiled with CFR 0.152.
 */
package TUIO;

import TUIO.TuioPoint;
import TUIO.TuioTime;
import java.util.ArrayList;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TuioContainer
extends TuioPoint {
    protected long session_id;
    protected float x_speed;
    protected float y_speed;
    protected float motion_speed;
    protected float motion_accel;
    protected Vector<TuioPoint> path;
    public static final int TUIO_ADDED = 0;
    public static final int TUIO_ACCELERATING = 1;
    public static final int TUIO_DECELERATING = 2;
    public static final int TUIO_STOPPED = 3;
    public static final int TUIO_REMOVED = 4;
    protected int state;

    TuioContainer(TuioTime tuioTime, long l, float f, float f2) {
        super(tuioTime, f, f2);
        this.session_id = l;
        this.x_speed = 0.0f;
        this.y_speed = 0.0f;
        this.motion_speed = 0.0f;
        this.motion_accel = 0.0f;
        this.path = new Vector();
        this.path.addElement(new TuioPoint(this.currentTime, this.xpos, this.ypos));
        this.state = 0;
    }

    TuioContainer(long l, float f, float f2) {
        super(f, f2);
        this.session_id = l;
        this.x_speed = 0.0f;
        this.y_speed = 0.0f;
        this.motion_speed = 0.0f;
        this.motion_accel = 0.0f;
        this.path = new Vector();
        this.path.addElement(new TuioPoint(this.currentTime, this.xpos, this.ypos));
        this.state = 0;
    }

    TuioContainer(TuioContainer tuioContainer) {
        super(tuioContainer);
        this.session_id = tuioContainer.getSessionID();
        this.x_speed = 0.0f;
        this.y_speed = 0.0f;
        this.motion_speed = 0.0f;
        this.motion_accel = 0.0f;
        this.path = new Vector();
        this.path.addElement(new TuioPoint(this.currentTime, this.xpos, this.ypos));
        this.state = 0;
    }

    @Override
    public void update(TuioTime tuioTime, float f, float f2) {
        TuioPoint tuioPoint = this.path.lastElement();
        super.update(tuioTime, f, f2);
        TuioTime tuioTime2 = this.currentTime.subtract(tuioPoint.getTuioTime());
        float f3 = (float)tuioTime2.getTotalMilliseconds() / 1000.0f;
        float f4 = this.xpos - tuioPoint.getX();
        float f5 = this.ypos - tuioPoint.getY();
        float f6 = (float)Math.sqrt(f4 * f4 + f5 * f5);
        float f7 = this.motion_speed;
        this.x_speed = f4 / f3;
        this.y_speed = f5 / f3;
        this.motion_speed = f6 / f3;
        this.motion_accel = (this.motion_speed - f7) / f3;
        this.path.addElement(new TuioPoint(this.currentTime, this.xpos, this.ypos));
        this.state = this.motion_accel > 0.0f ? 1 : (this.motion_accel < 0.0f ? 2 : 3);
    }

    public void stop(TuioTime tuioTime) {
        this.update(tuioTime, this.xpos, this.ypos);
    }

    public void update(TuioTime tuioTime, float f, float f2, float f3, float f4, float f5) {
        super.update(tuioTime, f, f2);
        this.x_speed = f3;
        this.y_speed = f4;
        this.motion_speed = (float)Math.sqrt(this.x_speed * this.x_speed + this.y_speed * this.y_speed);
        this.motion_accel = f5;
        this.path.addElement(new TuioPoint(this.currentTime, this.xpos, this.ypos));
        this.state = this.motion_accel > 0.0f ? 1 : (this.motion_accel < 0.0f ? 2 : 3);
    }

    public void update(float f, float f2, float f3, float f4, float f5) {
        super.update(f, f2);
        this.x_speed = f3;
        this.y_speed = f4;
        this.motion_speed = (float)Math.sqrt(this.x_speed * this.x_speed + this.y_speed * this.y_speed);
        this.motion_accel = f5;
        this.path.addElement(new TuioPoint(this.currentTime, this.xpos, this.ypos));
        this.state = this.motion_accel > 0.0f ? 1 : (this.motion_accel < 0.0f ? 2 : 3);
    }

    public void update(TuioContainer tuioContainer) {
        super.update(tuioContainer);
        this.x_speed = tuioContainer.getXSpeed();
        this.y_speed = tuioContainer.getYSpeed();
        this.motion_speed = tuioContainer.getMotionSpeed();
        this.motion_accel = tuioContainer.getMotionAccel();
        this.path.addElement(new TuioPoint(this.currentTime, this.xpos, this.ypos));
        this.state = this.motion_accel > 0.0f ? 1 : (this.motion_accel < 0.0f ? 2 : 3);
    }

    public void remove(TuioTime tuioTime) {
        this.currentTime = new TuioTime(tuioTime);
        this.state = 4;
    }

    public long getSessionID() {
        return this.session_id;
    }

    public float getXSpeed() {
        return this.x_speed;
    }

    public float getYSpeed() {
        return this.y_speed;
    }

    public TuioPoint getPosition() {
        return new TuioPoint(this.xpos, this.ypos);
    }

    public ArrayList<TuioPoint> getPath() {
        return new ArrayList<TuioPoint>(this.path);
    }

    public float getMotionSpeed() {
        return this.motion_speed;
    }

    public float getMotionAccel() {
        return this.motion_accel;
    }

    public int getTuioState() {
        return this.state;
    }

    public boolean isMoving() {
        return this.state == 1 || this.state == 2;
    }
}

