/****************************************************
 * oscP5sendreceive by andreas schlegel
 * example shows how to send and receive osc messages.
 * oscP5 website at http://www.sojamo.de/oscP5
 *
 * -Expects data sent from Max: UDP_OSC, sending "/test"
 *  with three integers added to the message (type "iii")
 */
import oscP5.*;
import netP5.*;
//-------------- Global Variables defined at top --------------------
int messgRec;  //-- Create integer variable for notifications from OSC
int oscValue1; //-- Create integer variable for data in osc Message
int oscValue2; //-- Create integer variable for data in osc Message
int oscValue3; //-- Create integer variable for data in osc Message
OscP5 oscP5;   //-- Create instance of OscP5 software object
 
void setup() {
  size(400,400);
  frameRate(25);
  /* start oscP5, listening for incoming messages at port 8800 */
  oscP5 = new OscP5(this, 8800); //-- Create instance of OscP5 called "oscP5"
}

void draw() { 
    background(oscValue1, oscValue2, oscValue3); 
}

/* incoming osc message are forwarded to the oscEvent method. */
void oscEvent(OscMessage theOscMessage) {
   if(theOscMessage.checkAddrPattern("/test")==true) {
 oscValue1 = theOscMessage.get(0).intValue(); //-- Get integer, if sent in message
 oscValue2 = theOscMessage.get(1).intValue(); //-- Get integer, if sent in message
 oscValue3 = theOscMessage.get(2).intValue(); //-- Get integer, if sent in message
 println("Values received: " + oscValue1 + " and " + oscValue2 + " and " + oscValue3);
   }
}
