/****************************************************
 * Adapted from oscP5sendreceive by andreas schlegel
 * example shows how to receive osc messages.
 * oscP5 website at http://www.sojamo.de/oscP5
 * Expecting OSC data from "OSC Controller" interface
 * It sends address patterns: toggle1 (1-3), button1 (1-3)
 * slider1 (1-4), slider2D (xy coords), gridToggle1 (1-24)
 * gridButton1 (1-24)
 */
 
import oscP5.*;
import netP5.*;
 //-------------- Global Variables defined at top -------------
String oscRec;  //-- Create variable for notifications from OSC
float oscvalueF1; //-- floating point data from OSC
float oscvalueF2; //-- floating point data from OSC
float oscvalueF3; //-- floating point data from OSC
PImage singer1; //-- Create variable of type "PImage"
PImage singer2;

OscP5 oscP5;    //-- Create software object of type "OscP5"

void setup() {
  /* start oscP5, listening for incoming messages at port 8800 */
  oscP5 = new OscP5(this,8800);  //-- Create instance of OscP5 object
  
  size(470,700);   //-- Create canvas 470 x 700 pixels
  frameRate(25);
  singer1 = loadImage("billie.jpg"); //-- Load image into "singer1" buffer
  singer2 = loadImage("judy.jpg");   //-- Load image into "singer2" buffer
}

void draw() { 
    if(oscRec == "billie") {
   image(singer1, 0, 0 );
    } else if (oscRec == "judy") {
   image(singer2, 0, 0 );
    } else {
      background(oscvalueF1 * 200, oscvalueF2 * 200, oscvalueF3 * 200 );
    }
}

void oscEvent(OscMessage theOscMessage) {
  /* check if theOscMessage has the address pattern we are looking for. */
  /* print the address pattern and the typetag of the received OscMessage */
  print("### received an osc message. - ");
  print(" addrpattern: "+ theOscMessage.addrPattern());
  println(" typetag: "+ theOscMessage.typetag());
  if(theOscMessage.checkAddrPattern("/oscControl/toggle1")==true){
  oscvalueF1 = theOscMessage.get(0).floatValue();
   } else if(theOscMessage.checkAddrPattern("/oscControl/toggle2")==true) {
     oscvalueF2 = theOscMessage.get(0).floatValue(); 
   } else if(theOscMessage.checkAddrPattern("/oscControl/toggle3")==true) {
     oscvalueF3 = theOscMessage.get(0).floatValue(); 
   }
  println(oscvalueF1  + " - " + oscvalueF2 + " - " + oscvalueF3);
//-- Expecting addrPattern sent from "OSCSurface" layout.
  if(theOscMessage.checkAddrPattern("/oscControl/toggle1")==true) {
    oscRec = "billie";
  } else if(theOscMessage.checkAddrPattern("/oscControl/toggle2")==true) {
    oscRec ="judy";
  } else {
    oscRec = "Something else.";
  }
}
