/****************************************************
 * Adapted from oscP5sendreceive by andreas schlegel
 * example shows how to receive osc messages.
 * oscP5 website at http://www.sojamo.de/oscP5
 * Expecting OSC data from "OSC Controller" (Android) interface
 * It sends address patterns: toggle1/ (1-3), button1/ (1-3)
 * slider1/ (1-4), slider2Dx/, slider2Dy/ (xy coords), 
 * gridToggle1/ (1-24), gridButton1/ (1-24)
 * This example uses slider2Dx/ and slider2Dy/
 */
 
import oscP5.*;
import netP5.*;
 //-------------- Global Variables defined at top -------------
String oscRec;  //-- Create variable for notifications from OSC
float oscValueX; //-- floating point data from OSC
float oscValueY; //-- floating point data from OSC

OscP5 oscP5;    //-- Create software object of type "OscP5"

void setup() {
  /* start oscP5, listening for incoming messages at port 8800 */
  oscP5 = new OscP5(this,8800);  //-- Create instance of OscP5 object
  
  size(470,700);   //-- Create canvas 470 x 700 pixels
  frameRate(25);
}

void draw() { 
      background(100, oscValueX * 200, oscValueY * 200 );
}

void oscEvent(OscMessage theOscMessage) {
  /* check if theOscMessage has the address pattern we are looking for. */
  /* print the address pattern and the typetag of the received OscMessage */
//  print("### received an osc message. - ");
//  print(" addrpattern: "+ theOscMessage.addrPattern());
//  println(" typetag: "+ theOscMessage.typetag());
  if(theOscMessage.checkAddrPattern("/oscControl/slider2Dy")==true){
  oscValueY = theOscMessage.get(0).floatValue();
  } else if (theOscMessage.checkAddrPattern("/oscControl/slider2Dx")==true){
  oscValueX = theOscMessage.get(0).floatValue();
  println("Values received: " + oscValueX + " : " + oscValueY);
   } else {
  println("addrPattern mismatch.");
   } 
}
