//-------------------------------------------
//    *** Processing code ***
//-------------------------------------
// -Checks for OSC message, change image.
// -Expects data sent with AddressPattern "/test"
//  with one integer added to the message (type "i")
//-------------------------------------
import oscP5.*;
import netP5.*;
//-------------- Global Variables defined at top --------------------
int oscValue1; //-- Create integer variable for data in osc Message
OscP5 oscP5;   //-- Create instance of OscP5 software object

PImage img1;  // Declare variable "img1" of type PImage
PImage img2;  // Declare variable "img2" of type PImage

void setup() {
   size(1090, 850);
   background(0);
   fill(0);
   img1 = loadImage("billie1.jpg");    // Load the image into the program 
   img2 = loadImage("a_gorman1.jpg");  // Load the image into the program 
     /* start oscP5, listening for incoming messages at port 8800 */
  oscP5 = new OscP5(this, 8800); //-- Create instance of OscP5 called "oscP5"
}

void draw() {    
   imageMode(CORNER);
       if(oscValue1 == 1){
       image(img1, 0, 0);
       } else if (oscValue1 == 2){
      image(img2, 0, 0);
       } else {
       rect(0, 0, width, height);      // rectangle covers (clears) screen  
     }
}

/* incoming osc message are forwarded to the oscEvent method. */
void oscEvent(OscMessage theOscMessage) {
   if(theOscMessage.checkAddrPattern("/test")==true) {
    println("Got it.");
    } else {
    println("Wrong AddrPattern.");  
    }
 oscValue1 = theOscMessage.get(0).intValue(); //-- Get integer, if sent in message
 println("Values received: " + oscValue1);
}
